require("scripts/maps/map_helpers.lua");
SetMapBackground("map/map_background_microwave");

somethingNotThere = GetRestaurantFolder("prehistoric") == "" and GetRestaurantFolder("ancientegpyt") == "" and GetRestaurantFolder("medieval") == "" and GetRestaurantFolder("pirateship") == "";
if (somethingNotThere or (GetCurrentGameMode() ~= 0 and GetLevelMode() == 0) ) then
	coords = { 120, 480 };
else
	coords = { 348, 390 };
end

MakeDialog
{
	Window
	{
		x = 0, y = 0, w = kMax, h = kMax,
		MakeRestaurantButtons('medieval', 605, 300, 415, 260);
		MakeRestaurantButtons('prehistoric', 80, 50, 35, 40);				
		MakeRestaurantButtons('ancientegpyt', 150, 330, 35, 320);		
		MakeRestaurantButtons('pirateship', 545, 30, 430, 20);
		
		MovingWindow
		{
			name="mapmicrowavetray",
			x=coords[1],
			y=coords[2],
 			dirX = 0,
 			dirY = 5,
 			startoff = 1,
 			onDelay = 500,	
			
			Bitmap
			{
				image = "map/map_tray_vertical",
				x = 0,
				y = 0,
				vflip = true,
				
				Text
				{
					x = 10, y = 95,
					w = kMax, h = kMax,
					flags = kHAlignCenter + kVAlignTop,
					name = 'mapuplabel',
					label = 'map_microwave_1',
					font = MapArrowFont,
				}
			};
			
			Button
			{
				x=34,
				y=20,
				name="mapup",
				graphics=NextMapUpGraphics,
				vflip = true,
				SelectLayer(0),
				Bitmap
				{
					x=22,
					y=18,
					image = 'map/microwave_logo'
				};
				SelectLayer(1),
				Bitmap
				{
					x=20,
					y=20,
					image = 'map/microwave_logo'
				};
				SelectLayer(2),
				Bitmap
				{
					x=22,
					y=18,
					image = 'map/microwave_logo'
				};
				command=
					function()
						SwitchMapPage('dinertown');
						SetupCurrentMapPage();
					end
			},
		};
		
		SetStyle(DefaultStyle);
	},
};

SlideMovingWindow('mapmicrowavetray', true);
HideRestaurantButtons('pirateship');
EnableWindow('prehistoric_rollover', false);
EnableWindow('ancientegpyt_rollover', false);
EnableWindow('medieval_rollover', false);
EnableWindow('pirateship_rollover', false);
